<?php
/**
* Auto detect language and currency
*
* NOTICE OF LICENSE
*
* This product is licensed for one customer to use on one installation (test stores and multishop included).
* Site developer has the right to modify this module to suit their needs, but can not redistribute the module in
* whole or in part. Any other use of this module constitues a violation of the user agreement.
*
* DISCLAIMER
*
* NO WARRANTIES OF DATA SAFETY OR MODULE SECURITY
* ARE EXPRESSED OR IMPLIED. USE THIS MODULE IN ACCORDANCE
* WITH YOUR MERCHANT AGREEMENT, KNOWING THAT VIOLATIONS OF
* PCI COMPLIANCY OR A DATA BREACH CAN COST THOUSANDS OF DOLLARS
* IN FINES AND DAMAGE A STORES REPUTATION. USE AT YOUR OWN RISK.
*
*  @author    idnovate
*  @copyright 2017 idnovate
*  @license   See above
*/

class GeoLocation
{
    //the geoPlugin server
    public $host = 'http://www.geoplugin.net/php.gp?ip={IP}&base_currency={CURRENCY}';

    //the default base currency
    public $currency = 'EUR';

    //initiate the geoPlugin vars
    public $ip = null;
    public $city = null;
    public $region = null;
    public $areaCode = null;
    public $dmaCode = null;
    public $countryCode = null;
    public $countryName = null;
    public $continentCode = null;
    public $latitude = null;
    public $longitude = null;
    public $currencyCode = null;
    public $currencySymbol = null;
    public $currencyConverter = null;

    public function __construct()
    {

    }
    
    public function geolocation()
    {
        return true;
    }

    public function locate($ip = null)
    {
        if (is_null($ip)) {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        $host = str_replace('{IP}', $ip, $this->host);
        $host = str_replace('{CURRENCY}', $this->currency, $host);
        $data = array();
        $response = $this->fetch($host, $ip);
        $this->ip = $ip;
        if (!is_object($response)) {
            $data = unserialize($response);
        } else {
            $data = (array)$response;
        }
        if (isset($data['geoplugin_countryCode'])) {
            $this->city = $data['geoplugin_city'];
            $this->region = $data['geoplugin_region'];
            $this->areaCode = $data['geoplugin_areaCode'];
            $this->dmaCode = $data['geoplugin_dmaCode'];
            $this->countryCode = $data['geoplugin_countryCode'];
            $this->countryName = $data['geoplugin_countryName'];
            $this->continentCode = $data['geoplugin_continentCode'];
            $this->latitude = $data['geoplugin_latitude'];
            $this->longitude = $data['geoplugin_longitude'];
            $this->currencyCode = $data['geoplugin_currencyCode'];
            $this->currencySymbol = $data['geoplugin_currencySymbol'];
            $this->currencyConverter = $data['geoplugin_currencyConverter'];
        } elseif (isset($data['country_code'])) {
            /*
            "ip":"83.36.23.43"
            "country_code":"ES"
            "country_name":"Spain"
            "region_code":"CT"
            "region_name":"Catalonia"
            "city":"Barcelona"
            "zip_code":"08002"
            "time_zone":"Europe/Madrid"
            "latitude":41.3888
            "longitude":2.159
            "metro_code":0
            */
            $this->city = $data['city'];
            $this->region = $data['region_code'];
            $this->areaCode = $data['region_code'];
            $this->dmaCode = $data['zip_code'];
            $this->countryCode = $data['country_code'];
            $this->countryName = $data['country_name'];
            $this->latitude = $data['latitude'];
            $this->longitude = $data['longitude'];
            $this->currencyCode = $this->_getCurrencyCodeFromCountryCode($this->countryCode);
            $this->currencySymbol = '';
            $this->currencyConverter = '';
        } elseif (isset($data['country'])) {
            /*
             "ip": "8.8.8.8",
              "hostname": "google-public-dns-a.google.com",
              "city": "Mountain View",
              "region": "California",
              "country": "US",
              "loc": "37.3860,-122.0838",
              "org": "AS15169 Google Inc.",
              "postal": "94040"
            */
            $this->city = $data['city'];
            $this->region = $data['region'];
            $this->areaCode = $data['region'];
            $this->dmaCode = $data['postal'];
            $this->countryCode = $data['country'];
            $this->countryName = $data['country'];
            $this->latitude = $data['loc'];
            $this->longitude = $data['loc'];
            $this->currencyCode = $this->_getCurrencyCodeFromCountryCode($this->countryCode);
            $this->currencySymbol = '';
            $this->currencyConverter = '';
        }
    }

    private function fetch($host, $ip = '')
    {
        if (function_exists('curl_init')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $host);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
            curl_setopt($ch, CURLOPT_TIMEOUT, 3);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_USERAGENT, 'geoPlugin PHP Class v1.0');
            //curl_setopt($ch, CURLOPT_VERBOSE, 1);
            $response = curl_exec($ch);
            if(curl_errno($ch)) {
                $curl_error = curl_error($ch);
            }
            $info = curl_getinfo($ch);
            curl_close($ch);
            if ($info['http_code'] != 200 || $curl_error == 'connect() timed out!') {
                $host = 'https://freegeoip.net/json/'.$ip;
                //$host = 'https://ipinfo.io/'.$ip.'/geo';
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $host);
                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
                curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_USERAGENT, 'geoPlugin PHP Class v1.0');
                //curl_setopt($ch, CURLOPT_VERBOSE, 1);
                $response = curl_exec($ch);
                //$info = curl_getinfo($ch);
                curl_close($ch);
                $response = Tools::jsonDecode($response);
            }
        } elseif (ini_get('allow_url_fopen')) {
            //fall back to fopen()
            $response = Tools::file_get_contents($host, 'r');
        } else {
            //trigger_error('geoPlugin class Error: Cannot retrieve data. Either compile PHP with cURL support or enable allow_url_fopen in php.ini ', E_USER_ERROR);
            return false;
        }
        return $response;
    }

    private function convert($amount, $float = 2, $symbol = true)
    {
        //easily convert amounts to geolocated currency.
        if (!is_numeric($this->currencyConverter) || $this->currencyConverter == 0) {
            trigger_error('geoPlugin class Notice: currencyConverter has no value.', E_USER_NOTICE);
            return $amount;
        }
        if (!is_numeric($amount)) {
            trigger_error('geoPlugin class Warning: The amount passed to geoPlugin::convert is not numeric.', E_USER_WARNING);
            return $amount;
        }
        if ($symbol === true) {
            return $this->currencySymbol.round(($amount * $this->currencyConverter), $float);
        } else {
            return round(($amount * $this->currencyConverter), $float);
        }
    }

    private function nearby($radius = 10, $limit = null)
    {
        if (!is_numeric($this->latitude) || !is_numeric($this->longitude)) {
            trigger_error('geoPlugin class Warning: Incorrect latitude or longitude values.', E_USER_NOTICE);
            return array(array());
        }
        $host = "http://www.geoplugin.net/extras/nearby.gp?lat=".$this->latitude."&long=".$this->longitude."&radius={$radius}";
        if (is_numeric($limit)) {
            $host .= "&limit={$limit}";
        }
        return unserialize($this->fetch($host));
    }

    protected function _getCurrencyCodeFromCountryCode($country_code)
    {
        $host = 'https://restcountries.eu/rest/v1/alpha/'.$country_code;
        if (function_exists('curl_init')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $host);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
            curl_setopt($ch, CURLOPT_TIMEOUT, 3);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_USERAGENT, 'geoPlugin PHP Class v1.0');
            //curl_setopt($ch, CURLOPT_VERBOSE, 1);
            $response = curl_exec($ch);
            if(curl_errno($ch)) {
                return '';
            }
            curl_close($ch);
        } elseif (ini_get('allow_url_fopen')) {
             $response = Tools::file_get_contents($host, 'r');
        } else {
            $response = '';
        }
        $response = Tools::jsonDecode($response);
        $currencies = $response->currencies;
        return $currencies[0];
    }

    /*
    * alternative to get currency code from country code
    */
    protected function _getCurrencyCodeFromCountryCodeAlt($country_code)
    {
        $host = 'http://country.io/currency.json'.$country_code;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $host);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 3);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_USERAGENT, 'geoPlugin PHP Class v1.0');
        //curl_setopt($ch, CURLOPT_VERBOSE, 1);
        $response = curl_exec($ch);
        //$info = curl_getinfo($ch);
        if(curl_errno($ch)) {
            return '';
        }
        curl_close($ch);
        $response = Tools::jsonDecode($response);
        return $response;
    }
}
